#include "SetSyncWaitCommand.h"
#include "../DataTypes/DataDouble.h"
#include "../DataTypes/DataString.h"
#include "SimulationEngineController.h"
namespace SimulationEngine
{

SetSyncWaitCommand::SetSyncWaitCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandSetSyncWaitKey())
{
}

SetSyncWaitCommand::~SetSyncWaitCommand()
{
}

list<DataParameter*> SetSyncWaitCommand::execute(list <DataParameter *> pars) 
{
	DataDouble *datadouble = (DataDouble *)(pars.front());
	SimulationEngineController::GetInstance()->SetSyncWait(datadouble->GetValue());
	list <DataParameter *> ret;
	ret.push_back(new DataString("Sync wait time has been successfully setted"));
	return ret;
}

}
